require( "scripts/style.lua" );

require( "scripts/upgrades.lua");

MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/longdialog",
		--x=kCenter,y=kCenter,w=kMax, h=kMax,
		
		UpgradeDialog
		{
			x = 0, y = 0, w=kMax, h=kMax,
			
			Text
			{
				font = HeaderFont,
				name = "selectupgrade",
				x=0,y=120,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectupgrade"
			};
			
			
			SetStyle(UpgradeStyle);
			BeginGroup();
			
			Button{
				name="button1",
				label="",
				x=UpgradeButtonX,
				y=UpgradeButtonY+(UpgradeButtonYSpace*0),
				w=425, h=100,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
					    Select(0)
					end  
			},
			
			Button{
				name="button2",
				label="",
				x=UpgradeButtonX,
				y=UpgradeButtonY+(UpgradeButtonYSpace*1),
				w=425, h=100,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
					    Select(1)
					end  
			},
			
			Button {
				name="button3",
				label="",
				x=UpgradeButtonX,
				y=UpgradeButtonY+(UpgradeButtonYSpace*2),
				w=425, h=100,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
					    Select(2)
					end  
			},
			
			SetStyle(DefaultStyle);

			Button{
				x = 800, -- hide the ok button initially
				y = 600,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="chooseok",
				label="ok",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						UpgradeIt()
						SaveUpgrade()
					    --PopModal(); -- take out upgrade menu
					    --PopModal(); -- take out this level
					end
			},
		}
	}
}